package gov.va.genisis2.dao.impl;

import gov.va.genisis2.dao.ILookUpDao;
import gov.va.genisis2.model.WorkflowStatus;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * The Class LookUpDao.
 * 
 * The LookUp data access object (DAO) is an object that provides an abstract
 * interface to some type of database or other persistence mechanism. 
 * By mapping application calls to the persistence layer, LookUp
 * DAO provide some specific data operations without exposing details of the database.
 */
 
@Repository
@Transactional(value = "transactionManager")
public class LookUpDao implements ILookUpDao {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(LookUpDao.class);

	/** The hibernate template. */
	@Autowired
	@Qualifier("hibernateTemplate")
	private HibernateTemplate hibernateTemplate;

	/**
	 * This method is used to get hibernate template.
	 * @return HibernateTemplate This returns hibernate template.
	 */
	public HibernateTemplate getHibernateTemplate() {
		return hibernateTemplate;
	}

	/**
	 * This method is used to set hibernate template.
	 * @param hibernateTemplate The hibernateTemplate.
	 */
	@Autowired
	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	/**
	 * This method is used to get status by id.
	 * @param statusDescription The statusDescription.
	 * @return int This returnes statusId.
	 */
	@Override
	public int getStatusId(String statusDescription) {
		int statusId;
		EntityManager entityManager = hibernateTemplate.getSessionFactory().createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<WorkflowStatus> query = criteriaBuilder.createQuery(WorkflowStatus.class);
		Root<WorkflowStatus> root = query.from(WorkflowStatus.class);
		Predicate condition = criteriaBuilder.equal(root.get("description"), statusDescription);
		query.where(condition);
		List<WorkflowStatus> requestList=null;
		try{
		 requestList = entityManager.createQuery(query).getResultList();
		} catch(Exception ex) {
			logger.error("Exception occured while doing lookup on " +statusDescription + ". Reason: " + ex.getMessage(),ex );
			return 0;
		}
		
		if (requestList == null || (requestList.isEmpty())) {
			statusId = 0;
			logger.error(statusDescription + " LookUp is not present in WorkStatus.");
		} else {
			statusId = requestList.get(0).getId();
		}

		return statusId;
	}

}
